/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWIDMLocalSaveOptionDialog;
import filenet.vw.apps.designer.VWSaveOptionDialog;
import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.CEObjectInfoCache;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class VWDesignerDocumentHelper {
    private static final Dimension DIM_LOCAL_SAVE_DIALOG = new Dimension(500, 175);
    private static final Dimension DIM_PACKAGE_OPTION_DIALOG = new Dimension(675, 125);
    private static final Dimension DIM_SAVE_OPTION_DIALOG = new Dimension(500, 175);
    public static final String TAG_PROCESS_DESIGNER = "Process Designer";
    private VWDesignerCoreData m_designerCoreData = null;
    private CEObjectInfoCache m_ceObjectInfoCache = null;
    private IVWIDMDocument m_IDMDoc = null;

    public VWDesignerDocumentHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public IVWIDMDocument getIDMDocument() {
        return this.m_IDMDoc;
    }

    public boolean saveToRepository() throws VWException {
        if (this.m_designerCoreData.getDesignerPreferences().getShouldAddCheckIn()) {
            if (this.m_designerCoreData.getProcessMenuHelper().getIsCollectionDirty() || this.m_IDMDoc == null) {
                this.m_designerCoreData.stopEditing();
                if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin() ? !this.checkinFileNetDocument() : !this.performFileNetAddItemAction()) {
                    return false;
                }
                if (this.m_IDMDoc != null && !this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckout()) {
                    this.m_IDMDoc.markCheckout();
                }
            }
            if (this.m_IDMDoc == null) {
                return false;
            }
        }
        return true;
    }

    public boolean getCanSaveAsPep() {
        try {
            if (this.m_designerCoreData.getScenarioMenuHelper().getScenarioCollectionDefinition() != null && this.m_designerCoreData.getScenarioMenuHelper().getScenarioCollectionDefinition().getScenarios() != null) {
                return false;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        switch (this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getSource()) {
            case 0: 
            case 1: {
                try {
                    VWWorkflowDefinition[] wflDefs = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getWorkflows();
                    return wflDefs.length == 1;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    break;
                }
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    public CEObjectInfoCache getCEObjectInfoCache(VWDataDictionary dataDictionary) throws VWException {
        if (this.m_ceObjectInfoCache == null) {
            this.m_ceObjectInfoCache = new CEObjectInfoCache(this.m_designerCoreData.getSessionInfo().getSession(), dataDictionary.getSystemConfiguration(), null);
        }
        return this.m_ceObjectInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performNewItemAction() {
        try {
            try {
                this.m_designerCoreData.displayWaitCursor();
                this.m_designerCoreData.getFileContext().resetSaveFilePath();
                this.reinitialize(null, null);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_2 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            Object var3_1 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    protected void performOpenItemAction() {
        String filePath = this.m_designerCoreData.getFileContext().getOpenFilePath(VWResource.s_fileOpenFilterNamePepXpdl);
        if (filePath != null) {
            this.openLocalFile(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openLocalFile(String filePath) {
        block25: {
            block20: {
                block24: {
                    block19: {
                        inStream = null;
                        try {
                            try {
                                if (filePath == null) {
                                    var7_3 = null;
                                    break block19;
                                }
                                this.m_designerCoreData.displayWaitCursor();
                                directory = "";
                                fileName = filePath;
                                nIndex = filePath.lastIndexOf("\\");
                                if (nIndex != -1) {
                                    directory = filePath.substring(0, nIndex) + "\\";
                                    fileName = filePath.substring(nIndex + 1, filePath.length());
                                }
                                this.m_designerCoreData.getFileContext().setSaveFilePath(directory, fileName);
                                inStream = new FileInputStream(filePath);
                                this.reinitialize(inStream, null);
                                inStream.close();
                                inStream = null;
                                break block20;
                            }
                            catch (SecurityException ex) {
                                VWDebug.logException(ex);
                                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_fileSecurityErrMsg, VWResource.s_fileSecurityErrTitle, 1);
                                this.performNewItemAction();
                                var7_5 = null;
                                try {
                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                this.m_designerCoreData.restoreDefaultCursor();
                                return;
                            }
                            catch (Exception ex) {
                                block22: {
                                    VWDebug.logException(ex);
                                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileOpenError, 1);
                                    this.performNewItemAction();
                                    var7_6 = null;
                                    ** try [egrp 2[TRYBLOCK] [9 : 194->205)] { 
lbl45:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block22;
lbl48:
                                    // 1 sources

                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                }
                                this.m_designerCoreData.restoreDefaultCursor();
                                return;
                            }
                        }
                        catch (Throwable var6_18) {
                            block23: {
                                var7_7 = null;
                                ** try [egrp 2[TRYBLOCK] [9 : 194->205)] { 
lbl57:
                                // 1 sources

                                if (inStream != null) {
                                    inStream.close();
                                }
                                break block23;
lbl60:
                                // 1 sources

                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            this.m_designerCoreData.restoreDefaultCursor();
                            throw var6_18;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [9 : 194->205)] { 
lbl67:
                    // 1 sources

                    if (inStream != null) {
                        inStream.close();
                    }
                    break block24;
lbl70:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.m_designerCoreData.restoreDefaultCursor();
                return;
            }
            var7_4 = null;
            ** try [egrp 2[TRYBLOCK] [9 : 194->205)] { 
lbl78:
            // 1 sources

            if (inStream != null) {
                inStream.close();
            }
            break block25;
lbl81:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        this.m_designerCoreData.restoreDefaultCursor();
    }

    protected boolean saveExistingDefinition(String saveOption) {
        block18: {
            try {
                this.m_designerCoreData.stopEditing();
                if (this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition() == null) {
                    return true;
                }
                if (!this.checkAuthorToolSignature()) {
                    return false;
                }
                if (this.m_designerCoreData.getSessionInfo().getCanSaveToDMS()) {
                    if (!this.checkInOrCancelCheckOutFileNetDocument(VWResource.s_cancelCheckout)) {
                        return false;
                    }
                    if (!this.m_designerCoreData.getProcessMenuHelper().getIsCollectionDirty()) {
                        return true;
                    }
                    String title = VWIDMBaseFactory.instance().getVWString(5).toString();
                    VWIDMLocalSaveOptionDialog saveDlg = new VWIDMLocalSaveOptionDialog(this.m_designerCoreData.getParentFrame(), title, this.m_IDMDoc != null, false);
                    if (saveDlg != null) {
                        saveDlg.setSize(DIM_LOCAL_SAVE_DIALOG);
                        saveDlg.setVisible(true);
                        switch (saveDlg.getStatus()) {
                            case 8: {
                                switch (saveDlg.getChoice()) {
                                    case 0: {
                                        if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin()) {
                                            return this.checkinFileNetDocument();
                                        }
                                        return this.performFileNetAddItemAction();
                                    }
                                    case 1: {
                                        return this.performFileNetAddItemAction();
                                    }
                                }
                                this.performSaveItemAction();
                                break;
                            }
                            default: {
                                return saveDlg.getStatus() != 4;
                            }
                        }
                    }
                    break block18;
                }
                if (!this.m_designerCoreData.getProcessMenuHelper().getIsCollectionDirty()) {
                    return true;
                }
                String title = VWIDMBaseFactory.instance().getVWString(5).toString();
                int nConfirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_exitQuestion, title, 1);
                if (nConfirmResult == 0) {
                    this.performSaveItemAction();
                    break block18;
                }
                return nConfirmResult != 2;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void performSaveItemAction() {
        block17: {
            FileOutputStream outStream;
            if (this.m_designerCoreData.getFileContext().isDefaultSaveFileName()) {
                this.performSaveAsItemAction();
            } else {
                outStream = null;
                String filePath = this.m_designerCoreData.getFileContext().getSaveFilePath(false);
                String backupFilePath = this.backupFile(filePath);
                outStream = new FileOutputStream(filePath);
                this.writeToStream(outStream);
                outStream.close();
                outStream = null;
                if (backupFilePath != null) {
                    this.cleanUpBackupFile(backupFilePath);
                }
                this.m_designerCoreData.getFileContext().setOpenFilePath(this.m_designerCoreData.getFileContext().getSaveDirectory(), this.m_designerCoreData.getFileContext().getSaveFileName());
                this.m_IDMDoc = null;
                VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 702, null);
                this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                Object var6_7 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                    break block17;
                }
                catch (Exception ex2) {}
            }
            break block17;
            {
                catch (SecurityException ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_fileSecurityErrMsg, VWResource.s_fileSecurityErrTitle, 1);
                    this.m_designerCoreData.getFileContext().resetSaveFilePath();
                    Object var6_8 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block17;
                    }
                    catch (Exception ex2) {}
                    break block17;
                }
                catch (Throwable throwable) {
                    VWDebug.logException(new Exception(VWResource.s_fileSaveErrTitle, throwable));
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), throwable.getLocalizedMessage(), VWResource.s_fileSaveErrTitle, 1);
                    this.m_designerCoreData.getFileContext().resetSaveFilePath();
                    Object var6_9 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block17;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void performSaveAsItemAction() {
        try {
            String filePath;
            String savedDir = this.m_designerCoreData.getFileContext().getSaveDirectory();
            String savedFile = this.m_designerCoreData.getFileContext().getSaveFileName();
            String wflName = this.getDefaultFileName(true);
            if (wflName != null && wflName.length() > 0) {
                this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, wflName);
            }
            if ((filePath = this.m_designerCoreData.getFileContext().getSaveFilePath(true)) == null) {
                this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, savedFile);
            } else {
                this.performSaveItemAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performFileNetOpenItemAction() {
        try {
            this.openFileNetDocument(null, true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNOpenErrTitle, 1);
            this.performNewItemAction();
        }
    }

    protected void getAndOpenFileNetDocument(String library, String docId, String version) {
        try {
            IVWIDMDocument IDMDoc;
            IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
            if (idmFactory != null && (IDMDoc = idmFactory.getIDMDocument(library, docId, version)) != null) {
                int confirmResult;
                boolean bCheckItOut = false;
                bCheckItOut = IDMDoc.isExclusiveLockOwner() ? true : (IDMDoc.canCheckin() ? (confirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_assumeCheckOut, VWResource.s_fnOpenTitle, 0)) == 0 : IDMDoc.canCheckout());
                this.openFileNetDocument(IDMDoc, bCheckItOut);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileOpenError, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void openFileNetDocument(IVWIDMDocument IDMDoc, boolean bCheckItOut) {
        block17: {
            ByteArrayInputStream inStream;
            byte[] fileContents;
            block15: {
                fileContents = null;
                inStream = null;
                if (IDMDoc == null) {
                    String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_open_withHK);
                    IVWIDMItem contextItem = this.m_designerCoreData.getFileContext().getIDMContextItem();
                    IVWIDMDialog dialog = VWIDMBaseFactory.instance().getOpenDialog(contextItem, resources[0], "WorkflowDefinition");
                    dialog.setTitle(VWResource.s_openFromDMSTitle);
                    dialog.setButtonMnemonic(resources[1]);
                    dialog.setButtonTooltip(VWResource.s_open);
                    int returnVal = dialog.showDialog(this.m_designerCoreData.getParentFrame());
                    if (0 == returnVal) {
                        IDMDoc = (IVWIDMDocument)dialog.getSelectedItem();
                        boolean bl = bCheckItOut = dialog.getMode() == 1;
                        if (!bCheckItOut && IDMDoc.canCheckin()) {
                            int confirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_assumeCheckOut, VWResource.s_menuFnOpen, 0);
                            boolean bl2 = bCheckItOut = confirmResult == 0;
                        }
                    }
                }
                if (IDMDoc == null) break block15;
                this.m_designerCoreData.displayWaitCursor();
                fileContents = IDMDoc.getContents(bCheckItOut);
                if (fileContents != null) {
                    inStream = new ByteArrayInputStream(fileContents);
                    this.reinitialize(inStream, IDMDoc);
                    fileContents = null;
                    inStream.close();
                    inStream = null;
                    break block15;
                }
                this.reinitialize(null, IDMDoc);
            }
            Object var11_11 = null;
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            fileContents = null;
            this.m_designerCoreData.restoreDefaultCursor();
            {
                break block17;
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNOpenErrTitle, 1);
                    Object var11_12 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    fileContents = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                fileContents = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected boolean performFileNetAddItemAction() {
        block18: {
            byte[] fileContents;
            ByteArrayOutputStream outStream;
            block15: {
                outStream = null;
                fileContents = null;
                outStream = new ByteArrayOutputStream();
                this.writeToStream(outStream);
                fileContents = outStream.toByteArray();
                String docClass = this.getDocClass();
                IVWIDMDialog dialog = VWIDMBaseFactory.instance().getAddDialog(this.m_designerCoreData.getParentFrame(), this.m_IDMDoc, fileContents, docClass);
                dialog.setTitle(VWIDMBaseFactory.instance().getVWString(22).toString());
                dialog.setFilename(this.getDefaultFileName(true));
                if (dialog.showDialog(this.m_designerCoreData.getParentFrame()) != 0) break block15;
                this.m_IDMDoc = (IVWIDMDocument)dialog.getSelectedItem();
                if (this.m_IDMDoc != null) {
                    this.m_designerCoreData.getFileContext().setIDMContextItem(this.m_IDMDoc);
                    if (this.m_IDMDoc.canCheckout() && !this.m_IDMDoc.isCheckedOut()) {
                        this.m_IDMDoc.checkoutNoUI();
                    }
                }
                VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 702, null);
                this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                boolean bl = true;
                Object var8_8 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                fileContents = null;
                return bl;
            }
            Object var8_9 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            fileContents = null;
            {
                break block18;
                catch (Throwable throwable) {
                    VWDebug.logException(new Exception(VWResource.s_FNSaveAsErrTitle, throwable));
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), throwable.getLocalizedMessage(), VWResource.s_FNSaveAsErrTitle, 1);
                    Object var8_10 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    fileContents = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                fileContents = null;
                throw throwable;
            }
        }
        return false;
    }

    protected boolean checkInOrCancelCheckOutFileNetDocument(String optionString) {
        try {
            if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin()) {
                if (optionString == null) {
                    optionString = VWResource.s_cancelCheckout;
                }
                Toolkit.getDefaultToolkit().beep();
                String title = VWIDMBaseFactory.instance().getVWString(5).toString();
                VWSaveOptionDialog saveOptionDialog = new VWSaveOptionDialog(this.m_designerCoreData.getParentFrame(), title, optionString);
                saveOptionDialog.setSize(DIM_SAVE_OPTION_DIALOG);
                saveOptionDialog.setVisible(true);
                switch (saveOptionDialog.getStatus()) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        if (saveOptionDialog.getChoice() == 2) {
                            this.checkinFileNetDocument();
                            break;
                        }
                        this.m_IDMDoc.cancelCheckoutNoUI();
                    }
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performFileNetCheckinItemAction() {
        try {
            try {
                this.m_designerCoreData.stopEditing();
                if (this.checkAuthorToolSignature()) {
                    this.m_designerCoreData.displayWaitCursor();
                    if (this.checkinFileNetDocument()) {
                        VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 702, null);
                        this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                        boolean bl = true;
                        Object var4_4 = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return bl;
                    }
                }
                Object var4_5 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return false;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getSessionInfo().getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var4_6 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFileNetCancelCheckoutItemAction() {
        try {
            block4: {
                try {
                    this.m_designerCoreData.displayWaitCursor();
                    if (this.m_IDMDoc == null || !this.m_IDMDoc.canCancelCheckout()) break block4;
                    this.m_IDMDoc.cancelCheckoutNoUI();
                    VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 702, null);
                    this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNCancelCheckoutErrTitle, 1);
                    Object var3_4 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            Object var3_3 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performFileNetSaveItemAction() {
        block25: {
            block19: {
                block24: {
                    block20: {
                        block23: {
                            block18: {
                                this.m_designerCoreData.stopEditing();
                                outStream = null;
                                fileContents = null;
                                try {
                                    try {
                                        if (!this.checkAuthorToolSignature()) {
                                            var3_3 = false;
                                            var6_6 = null;
                                            break block18;
                                        }
                                        this.m_designerCoreData.displayWaitCursor();
                                        if (this.m_IDMDoc == null || !this.m_IDMDoc.isCheckedOut() || !this.m_IDMDoc.canCheckin()) break block19;
                                        this.m_designerCoreData.displayWaitCursor();
                                        outStream = new ByteArrayOutputStream();
                                        this.writeToStream(outStream);
                                        fileContents = outStream.toByteArray();
                                        this.m_IDMDoc.setMimeType(this.getMimeType());
                                        this.m_IDMDoc.saveContents(fileContents, this.getDefaultFileName(true));
                                        coordinationEvent = new VWCoordinationEvent(this, 702, null);
                                        this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                                        var4_16 = true;
                                        break block20;
                                    }
                                    catch (Throwable throwable) {
                                        VWDebug.logException(new Exception(VWResource.s_FNSaveErrTitle, throwable));
                                        VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), throwable.getLocalizedMessage(), VWResource.s_FNSaveErrTitle, 1);
                                        var6_9 = null;
                                        try {
                                            if (outStream != null) {
                                                outStream.close();
                                            }
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        fileContents = null;
                                        this.m_designerCoreData.restoreDefaultCursor();
                                        return false;
                                    }
                                }
                                catch (Throwable var5_17) {
                                    block22: {
                                        var6_10 = null;
                                        ** try [egrp 2[TRYBLOCK] [7 : 203->214)] { 
lbl44:
                                        // 1 sources

                                        if (outStream != null) {
                                            outStream.close();
                                        }
                                        break block22;
lbl47:
                                        // 1 sources

                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                    }
                                    fileContents = null;
                                    this.m_designerCoreData.restoreDefaultCursor();
                                    throw var5_17;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [7 : 203->214)] { 
lbl55:
                            // 1 sources

                            if (outStream != null) {
                                outStream.close();
                            }
                            break block23;
lbl58:
                            // 1 sources

                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        fileContents = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return var3_3;
                    }
                    var6_7 = null;
                    ** try [egrp 2[TRYBLOCK] [7 : 203->214)] { 
lbl67:
                    // 1 sources

                    if (outStream != null) {
                        outStream.close();
                    }
                    break block24;
lbl70:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                fileContents = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return var4_16;
            }
            var6_8 = null;
            ** try [egrp 2[TRYBLOCK] [7 : 203->214)] { 
lbl79:
            // 1 sources

            if (outStream != null) {
                outStream.close();
            }
            break block25;
lbl82:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        fileContents = null;
        this.m_designerCoreData.restoreDefaultCursor();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performExportToFlattenedXPDLAction() {
        String savedDir = this.m_designerCoreData.getFileContext().getSaveDirectory();
        String savedFile = this.m_designerCoreData.getFileContext().getSaveFileName();
        try {
            try {
                String saveFilePath;
                this.m_designerCoreData.stopEditing();
                if (!this.checkAuthorToolSignature()) {
                    Object var6_3 = null;
                    this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, savedFile);
                    this.m_designerCoreData.restoreDefaultCursor();
                    return;
                }
                String wflName = this.getDefaultFileName(false);
                if (wflName != null && wflName.length() > 0) {
                    this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, wflName);
                }
                if ((saveFilePath = this.m_designerCoreData.getFileContext().getSaveFilePath(true)) != null) {
                    this.m_designerCoreData.displayWaitCursor();
                    this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().exportToFile(saveFilePath, this.m_designerCoreData.getSessionInfo().getSession());
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getSessionInfo().getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var6_5 = null;
                this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, savedFile);
                this.m_designerCoreData.restoreDefaultCursor();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, savedFile);
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
        Object var6_4 = null;
        this.m_designerCoreData.getFileContext().setSaveFilePath(savedDir, savedFile);
        this.m_designerCoreData.restoreDefaultCursor();
    }

    private void reinitialize(InputStream inStream, IVWIDMDocument IDMDoc) throws VWException {
        this.m_IDMDoc = IDMDoc;
        this.m_designerCoreData.getFileContext().setIDMContextItem(this.m_IDMDoc);
        VWWorkflowCollectionDefinition workflowCollectionDefinition = null;
        boolean bCreateNewWorkflow = false;
        if (inStream == null) {
            workflowCollectionDefinition = new VWWorkflowCollectionDefinition();
            workflowCollectionDefinition.setName(VWResource.s_defaultPackageName);
            workflowCollectionDefinition.setAuthorTool(TAG_PROCESS_DESIGNER);
            bCreateNewWorkflow = true;
        } else {
            workflowCollectionDefinition = VWWorkflowCollectionDefinition.read(inStream);
            if (workflowCollectionDefinition == null) {
                throw new VWException("vw.apps.designer.NotAPepFile", "The selected file is not a PEP file.");
            }
            String name = workflowCollectionDefinition.getName();
            if (name == null || name.trim().length() == 0) {
                workflowCollectionDefinition.setName(VWResource.s_defaultPackageName);
            }
        }
        VWCoordinationEvent coordinationEvent = new VWCoordinationEvent(this, 700, workflowCollectionDefinition);
        this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
        if (bCreateNewWorkflow) {
            this.m_designerCoreData.getProcessMenuHelper().addNewProcess();
            this.m_designerCoreData.getProcessMenuHelper().clearCollectionDirtyFlag();
        } else {
            VWWorkflowDefinition mainWflDef = workflowCollectionDefinition.getMainWorkflow();
            if (mainWflDef != null) {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 716, mainWflDef);
            }
        }
    }

    private boolean checkAuthorToolSignature() throws Exception {
        String authorToolSignature = null;
        VWWorkflowCollectionDefinition wflCollDef = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition();
        if (wflCollDef != null) {
            authorToolSignature = wflCollDef.getAuthorTool();
        }
        if (authorToolSignature != null && VWStringUtils.compare(authorToolSignature, TAG_PROCESS_DESIGNER) != 0) {
            int result = VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_foreignFile, VWResource.s_overwriting, 4, 3, (Icon)VWImageLoader.createImageIcon("question.gif"), VWDesignerDocumentHelper.DIM_PACKAGE_OPTION_DIALOG.width, VWDesignerDocumentHelper.DIM_PACKAGE_OPTION_DIALOG.height);
            if (result == 1) {
                if (wflCollDef != null) {
                    wflCollDef.setAuthorTool(TAG_PROCESS_DESIGNER);
                }
                return true;
            }
        } else {
            if (wflCollDef != null) {
                wflCollDef.setAuthorTool(TAG_PROCESS_DESIGNER);
            }
            return true;
        }
        return false;
    }

    private String backupFile(String filePath) {
        try {
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            int nAvailable = (int)((double)freeMemory / (double)totalMemory * 100.0);
            System.out.println("Available Memory = " + nAvailable + "%");
            File file = new File(filePath);
            if (file.exists() && file.isFile()) {
                boolean bOkToRename = true;
                File backupFile = new File(filePath + ".backup");
                if (backupFile.exists()) {
                    bOkToRename = backupFile.delete();
                }
                if (bOkToRename && file.renameTo(backupFile)) {
                    return backupFile.getCanonicalPath();
                }
                return file.getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean cleanUpBackupFile(String filePath) {
        try {
            File backupFile = new File(filePath);
            if (backupFile.exists() && backupFile.isFile()) {
                return backupFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private String getDefaultFileName(boolean bAllowPep) {
        if (bAllowPep && this.getCanSaveAsPep()) {
            String workflowName = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getMainWorkflow().getName();
            if (workflowName == null || workflowName.length() == 0) {
                workflowName = VWResource.s_untitled;
            }
            return VWResource.s_fileSaveFilterNameTemplatePep.toString(workflowName);
        }
        String workflowCollectionName = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getName();
        if (workflowCollectionName == null || workflowCollectionName.length() == 0) {
            workflowCollectionName = VWResource.s_untitled;
        }
        return VWResource.s_fileSaveFilterNameTemplateXpdl.toString(workflowCollectionName);
    }

    private String getDocClass() throws VWException {
        if (this.getCanSaveAsPep()) {
            return "WorkflowDefinition";
        }
        return "XPDL_WorkflowDefinition";
    }

    private int getMimeType() throws VWException {
        if (this.getCanSaveAsPep()) {
            return 1;
        }
        return 2;
    }

    private void writeToStream(OutputStream outStream) throws VWException {
        if (this.getCanSaveAsPep()) {
            VWWorkflowDefinition[] wflDefs = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getWorkflows();
            wflDefs[0].write(outStream);
        } else {
            this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().write(outStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkinFileNetDocument() {
        block22: {
            block17: {
                block21: {
                    outStream = null;
                    fileContents = null;
                    try {
                        try {
                            if (this.m_IDMDoc == null || !this.m_IDMDoc.isCheckedOut() || !this.m_IDMDoc.canCheckin()) break block17;
                            this.m_designerCoreData.displayWaitCursor();
                            outStream = new ByteArrayOutputStream();
                            this.writeToStream(outStream);
                            fileContents = outStream.toByteArray();
                            try {
                                fileName = this.getDefaultFileName(true);
                                this.m_IDMDoc.setMimeType(this.getMimeType());
                                if (!this.m_IDMDoc.checkin(this.m_designerCoreData.getParentFrame(), fileContents, true, fileName, VWResource.s_checkinWorkflowDefinition)) break block17;
                                coordinationEvent = new VWCoordinationEvent(this, 702, null);
                                this.m_designerCoreData.notifyDocumentStateChanged(coordinationEvent, true);
                                var5_7 = true;
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_FNSaveErrTitle, 1);
                                break block17;
                            }
                            var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            VWDebug.logException(new Exception(VWResource.s_FNSaveErrTitle, throwable));
                            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), throwable.getLocalizedMessage(), VWResource.s_FNSaveErrTitle, 1);
                            var7_10 = null;
                            try {
                                if (outStream != null) {
                                    outStream.close();
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            fileContents = null;
                            this.m_designerCoreData.restoreDefaultCursor();
                            return false;
                        }
                    }
                    catch (Throwable var6_16) {
                        block20: {
                            var7_11 = null;
                            ** try [egrp 3[TRYBLOCK] [7 : 220->231)] { 
lbl46:
                            // 1 sources

                            if (outStream != null) {
                                outStream.close();
                            }
                            break block20;
lbl49:
                            // 1 sources

                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        fileContents = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        throw var6_16;
                    }
                    ** try [egrp 3[TRYBLOCK] [7 : 220->231)] { 
lbl57:
                    // 1 sources

                    if (outStream != null) {
                        outStream.close();
                    }
                    break block21;
lbl60:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                fileContents = null;
                this.m_designerCoreData.restoreDefaultCursor();
                return var5_7;
            }
            var7_9 = null;
            ** try [egrp 3[TRYBLOCK] [7 : 220->231)] { 
lbl69:
            // 1 sources

            if (outStream != null) {
                outStream.close();
            }
            break block22;
lbl72:
            // 1 sources

            catch (Exception ex) {
                // empty catch block
            }
        }
        fileContents = null;
        this.m_designerCoreData.restoreDefaultCursor();
        return false;
    }
}

